// Define global variables
var SEARCHANY     = 1;
var SEARCHALL     = 2;
var SEARCHURL     = 4;
var searchType  = '';
var showMatches   = 400;
var currentMatch  = 0;
var copyArray   = new Array();
var docObj      = parent.frames['eAISNavigation'].document;

// Determine the type of search, and make
// sure the user has entered something

function refresh()
{
    window.location.replace( sURL );
}

function validate(entry)
{  
  docObj = parent.frames['eAISNavigation'].document;
  if (document.forms[0].findAll.checked){
  	searchType = SEARCHALL;
  }
  else { searchType = SEARCHANY; }
  while (entry.charAt(0) == ' ') {
    entry = entry.substring(1,entry.length);
    document.forms[0].query.value = entry;
    }
  while (entry.charAt(entry.length - 1) == ' ') {
    entry = entry.substring(0,entry.length - 1);
    document.forms[0].query.value = entry;
    }
  if (entry.length == 0) {
    document.forms[0].query.value = '';
    noMatch2();
	return;
    }
  convertString(entry);
  }

// Put the search terms in an array and
// and call appropriate search algorithm
function convertString(reentry) {
  var searchArray = reentry.split(" ");
  if (searchType == (SEARCHALL)) { requireAll(searchArray); }
  else { allowAny(searchArray); }
  }

// Define a function to perform a search that requires
// a match of any of the terms the user provided
function allowAny(t) {
  var findings = new Array(0);
  for (i = 0; i < profiles.length; i++) {
    var compareElement  = profiles[i].toUpperCase();
    if(searchType == SEARCHANY) { var refineElement  = compareElement.substring(0,compareElement.indexOf('|FILE')); }
    else { var refineElement = compareElement.substring(compareElement.indexOf('|FILE'), compareElement.length); }
    for (j = 0; j < t.length; j++) {
      var compareString = t[j].toUpperCase();
      if (refineElement.indexOf(compareString) != -1) {
        findings[findings.length] = profiles[i];
        break;
        }
      }
    }
  verifyManage(findings);
  }

// Define a function to perform a search that requires
// a match of all terms the user provided
function requireAll(t) {
  var findings = new Array();
  for (i = 0; i < profiles.length; i++) {
    var allConfirmation = true;
    var allString       = profiles[i].toUpperCase();
    var refineAllString = allString.substring(1,allString.indexOf('|FILE'));
    for (j = 0; j < t.length; j++) {
      var allElement = t[j].toUpperCase();
      if (refineAllString.indexOf(allElement) == -1) {
        allConfirmation = false;
        continue;
        }
      }
    if (allConfirmation) {
      findings[findings.length] = profiles[i];
      }
    }
  verifyManage(findings);
  }

// Determine whether the search was successful
// If so print the results; if not, indicate that, too
function verifyManage(resultSet) {
  if (resultSet.length == 0) { noMatch(); }
  else {
    copyArray = resultSet.sort();
    formatResults(copyArray, currentMatch, showMatches);
    }
  }

// Define a function that indicates that the returned no results
function noMatch2() {
  docObj.open();
  docObj.writeln('<HTML><HEAD><TITLE>Search Results</TITLE></HEAD>' +
    '<BODY BGCOLOR=WHITE TEXT=BLACK></BODY></HTML>');
  docObj.close();
  document.forms[0].query.select();
  }

// Define a function that indicates that the returned no results
function noMatch() {
  docObj.open();
  docObj.writeln('<HTML><HEAD><TITLE>Search Results</TITLE></HEAD>' +
    '<BODY BGCOLOR=WHITE TEXT=BLACK>' +
     '<link rel="stylesheet" href="../menu.css" type="text/css"/>' +
    '<TABLE WIDTH=90% BORDER=0 ALIGN=CENTER><TR><TD VALIGN=TOP><DL>' +
    '<HR NOSHADE WIDTH=100%>"' + document.forms[0].query.value +
    '" returned no results.<HR NOSHADE WIDTH=100%></TD></TR></TABLE></BODY></HTML>');
  docObj.close();
  document.forms[0].query.select();
  }




// Define a function to print the results of a successful search
function formatResults(results, reference, offset) {
  var currentRecord = (results.length < reference + offset ? results.length : reference + offset);
  docObj.open();
  docObj.writeln('<HTML>\n<HEAD>\n<TITLE>Search Results</TITLE>\n</HEAD>' +
    '<BODY BGCOLOR=WHITE TEXT=BLACK>' +
        '<link rel="stylesheet" href="../menu.css" type="text/css"/>' +
    '<TABLE WIDTH=90% BORDER=0 ALIGN=CENTER CELLPADDING=3><TR><TD>' +
    '<HR NOSHADE WIDTH=100%></TD></TR><TR/><TR/><TR/><TR><TD VALIGN=TOP><FONT FACE=Arial><B>' +
    results.length + ' documents found' +
    '<FONT FACE=Arial SIZE=-1><B>' + '\n\n\n\n\t<DL>');
  if (searchType == SEARCHURL) {
    for (var i = reference; i < currentRecord; i++) {
      var divide = results[i].split("|");
      docObj.writeln('\t<DT>' + '<A HREF="' + divide[2] + '">' + divide[2] + '</A>' +
        '\t<DD>' + '<I>' + divide[1] + '</I><P>\n\n');
      }
    }
  else {
    for (var i = reference; i < currentRecord; i++) {
      var divide = results[i].split('|');
      var dividedDocName = divide[0].split('*');
      //In IE8 we are getting garbage in the second split string if it should be empty
	  if (dividedDocName[1].length <=3){
	   docObj.writeln('\n\n\t<DT>' + '<div class="H2"><A target="eAISContent" HREF="' + divide[2].substring(5) + '">' +
	        '<span class="Number">' + dividedDocName[0] + '</span></A></div>\t<DD><I></I><P>');
	  }
	  else
      {
      docObj.writeln('\n\n\t<DT>' + '<div class="H2"><A target="eAISContent" HREF="' + divide[2].substring(5) + '">' +
      '<span class="Number">' + dividedDocName[0] +'</span>' + dividedDocName[1] +'</A></div>\t<DD><I></I><P>');
        }
     }
  }
  docObj.writeln('\n\t</DL>\n\n\n\n');
  prevNextResults(results.length, reference, offset);
  docObj.writeln('<HR NOSHADE WIDTH=100%>' +
    '</TD>\n</TR>\n</TABLE>\n</BODY>\n</HTML>');
  docObj.close();
  document.forms[0].query.select();
  }

// Define a function to dynamically display Prev and Next buttons
function prevNextResults(ceiling, reference, offset) {
  docObj.writeln('<CENTER><FORM>');
  if(reference > 0) {
    docObj.writeln('<INPUT TYPE=BUTTON VALUE="Prev ' + offset + ' Results" ' +
      'onClick="parent.frames[0].formatResults(parent.frames[0].copyArray, ' +
      (reference - offset) + ', ' + offset + ')">');
    }
  if(reference >= 0 && reference + offset < ceiling) {
    var trueTop = ((ceiling - (offset + reference) < offset) ? ceiling - (reference + offset) : offset);
    var howMany = (trueTop > 1 ? "s" : "");
    docObj.writeln('<INPUT TYPE=BUTTON VALUE="Next ' + trueTop + ' Result' + howMany + '" ' +
      'onClick="parent.frames[0].formatResults(parent.frames[0].copyArray, ' +
      (reference + offset) + ', ' + offset + ')">');
    }
  docObj.writeln('</CENTER>');
  }

